<!DOCTYPE html>
<html lang="<?php _trans('cldr'); ?>">
<head>
    <meta charset="utf-8">
    <title><?php _trans('Client'); ?></title>
    <link rel="stylesheet"
          href="<?php echo base_url(); ?>assets/<?php echo get_setting('system_theme', 'invoiceplane'); ?>/css/templates.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/core/css/custom-pdf.css">
</head>
<body>
<header class="clearfix">

    <div id="logo">
        <?php echo invoice_logo_pdf(); ?>
    </div>

    <h2 style="text-align: center; font-weight: bold;"><?php echo trans('All Inactive Clients'); ?><br/></h2>
</header>

<main>




    <table class="item-table">
        <thead>
        <tr>
            <th class="item-name"><?php _trans('Status'); ?></th>
            <th class="item-desc"><?php _trans('Name'); ?></th>
            <th class="item-desc"><?php _trans('Email Address'); ?></th>
            <th class="item-desc"><?php _trans('Contact'); ?></th>

        </tr>
        </thead>
        <tbody>
        <?php foreach( $Clients as $client ) {?>
            <tr>
            <td><?php if ($client->client_active == 1) { echo 'Active'; } else { echo 'Inactive'; } ?></td>
                <td><?php echo$client->client_name ?></td>
                <td><?php echo$client->client_email ?></td>
                <td><?php echo$client->client_phone ?></td>

            </tr>

<?php }?>
        </tbody>

    </table>

</main>

<footer>
<p> <strong> Total Clients: <?php echo count($Clients); ?> </strong></p>
</footer>

</body>
</html>
